

$(function () {
  "use strict";


  /* scrollar */

    if (document.querySelector(".notify-list")) {
      new PerfectScrollbar(".notify-list");
    }
    
    if (document.querySelector(".search-content")) {
      new PerfectScrollbar(".search-content");
    }
  // new PerfectScrollbar(".mega-menu-widgets")



  /* toggle button */

  $(".btn-toggle").click(function () {
    $("body").hasClass("toggled") ? ($("body").removeClass("toggled"), $(".sidebar-wrapper").unbind("hover")) : ($("body").addClass("toggled"), $(".sidebar-wrapper").hover(function () {
      $("body").addClass("sidebar-hovered")
    }, function () {
      $("body").removeClass("sidebar-hovered")
    }))
  })




  /* menu */

  $(function () {
    function initMetisMenu() {
      if (typeof $.fn.metisMenu === 'function') {
        try {
          $('#sidenav').metisMenu();
        } catch(e) {
          console.error('Error initializing metisMenu:', e);
        }
      }
    }

    if (typeof $.fn.metisMenu === 'function') {
      initMetisMenu();
    } else {
      var attempts = 0;
      var checkInterval = setInterval(function() {
        attempts++;
        if (typeof $.fn.metisMenu === 'function') {
          initMetisMenu();
          clearInterval(checkInterval);
        } else if (attempts > 10) {
          clearInterval(checkInterval);
          console.warn('metisMenu plugin not loaded after 10 attempts');
        }
      }, 100);
    }
  });

  $(".sidebar-close").on("click", function () {
    $("body").removeClass("toggled")
  })



  /* dark mode button */

  function updateDarkModeIcon() {
    const currentTheme = $("html").attr("data-bs-theme");
    const isDark = currentTheme === 'dark';
    $(".dark-mode i").text(isDark ? 'light_mode' : 'dark_mode');
  }

  $(".dark-mode").click(function () {
    $("html").attr("data-bs-theme", function (i, v) {
      const newTheme = v === 'dark' ? 'light' : 'dark';
      localStorage.setItem("selectedTheme", newTheme);
      return newTheme;
    });
    updateDarkModeIcon();
  });

  updateDarkModeIcon();



  /* switcher */

  function setTheme(theme) {
    $("html").attr("data-bs-theme", theme);
    localStorage.setItem("selectedTheme", theme);
    updateDarkModeIcon();
  }

  function loadSavedTheme() {
    const savedTheme = localStorage.getItem("selectedTheme");
    if (savedTheme) {
      $("html").attr("data-bs-theme", savedTheme);
      
      $("input[name='theme-options']").prop("checked", false);
      if (savedTheme === "light") {
        $("#LightTheme").prop("checked", true);
      } else if (savedTheme === "dark") {
        $("#DarkTheme").prop("checked", true);
      } else if (savedTheme === "semi-dark") {
        $("#SemiDarkTheme").prop("checked", true);
      } else if (savedTheme === "bodered-theme") {
        $("#BoderedTheme").prop("checked", true);
      }
      updateDarkModeIcon();
    }
  }

  loadSavedTheme();

  $("#LightTheme").on("click", function () {
    setTheme("light");
  }),

    $("#DarkTheme").on("click", function () {
      setTheme("dark");
    }),

    $("#SemiDarkTheme").on("click", function () {
      setTheme("semi-dark");
    }),

    $("#BoderedTheme").on("click", function () {
      setTheme("bodered-theme");
    })



  /* search control */

  $(".search-control").click(function () {
    $(".search-popup").addClass("d-block");
    $(".search-close").addClass("d-block");
  });


  $(".search-close").click(function () {
    $(".search-popup").removeClass("d-block");
    $(".search-close").removeClass("d-block");
  });


  $(".mobile-search-btn").click(function () {
    $(".search-popup").addClass("d-block");
  });


  $(".mobile-search-close").click(function () {
    $(".search-popup").removeClass("d-block");
  });




  /* menu active */

  $(function () {
    try {
      var menuItems = $(".metismenu li a").filter(function () {
        return this.href == window.location;
      });
      if(menuItems.length > 0) {
        var active = menuItems.addClass("").parent().addClass("mm-active");
        while (active.is("li")) {
          active = active.parent("").addClass("mm-show").parent("").addClass("mm-active");
        }
      }
    } catch(e) {
      console.warn('Error setting menu active state:', e);
    }
  });



});










