<?php
if(defined('FUNGSI_FLASH_LOADED')) return;
define('FUNGSI_FLASH_LOADED', true);

if( !function_exists( 'flash' ) )
{
    /**
     * Function to create and display error and success messages
     * @access public
     * @param string session name
     * @param string message
     * @param string display class
     * @return string message
     */
    function flash( $name = '', $message = '', $class = 'alert-warning' )
    {
        //We can only do something if the name isn't empty
        if( !empty( $name ) )
        {
            //No message, create it
            if( !empty( $message ) && empty( $_SESSION[$name] ) )
            {
                if( !empty( $_SESSION[$name] ) )
                {
                    unset( $_SESSION[$name] );
                }
                if( !empty( $_SESSION[$name.'_class'] ) )
                {
                    unset( $_SESSION[$name.'_class'] );
                }

                $_SESSION[$name] = $message;
                $_SESSION[$name.'_class'] = $class;
            }
            //Message exists, display it
            elseif( !empty( $_SESSION[$name] ) && empty( $message ) )
            {
                $class = !empty( $_SESSION[$name.'_class'] ) ? $_SESSION[$name.'_class'] : 'alert-warning';
                ?>
                <br>
                <div class="alert <?php echo $class ?> border-0 bg-warning alert-dismissible fade show">
				<div class="d-flex align-items-center">
					<div class="font-35 text-dark"><span class="material-icons-outlined fs-2">report_problem</span>
					</div>
					<div class="ms-3">
						<h6 class="mb-0 text-dark">Warning Alerts</h6>
						<div class="text-dark"><?php echo $_SESSION[$name] ?></div>
					</div>
				</div>
				<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
			</div>
                <?php

                unset($_SESSION[$name]);
                unset($_SESSION[$name.'_class']);
            }
        }
    }
}

?>
