<?php
session_start();
// Jika user sudah login, langsung arahkan ke index
if (isset($_SESSION['login_user'])) {
    header("Location: index.php");
    exit;
}
?>
<!doctype html>
<html lang="en" data-bs-theme="light">
  <!-- Mirrored from codervent.com/matoxi/demo/vertical-menu/auth-basic-login.html by HTTrack Website Copier/3.x [XR&CO'2014], Sun, 02 Nov 2025 09:54:05 GMT -->
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>LOGIN | PATRA RAYA</title>
    <!--favicon-->
    <link rel="icon" href="assets/images/favicon.png" type="image/png">
    <!--plugins-->
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/plugins/metismenu/metisMenu.min.css">
    <link rel="stylesheet" type="text/css" href="assets/plugins/metismenu/mm-vertical.css">
    <!--bootstrap css-->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/fonts/css2ab59.css?family=Noto+Sans:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="assets/fonts/cssf511.css?family=Material+Icons+Outlined" rel="stylesheet">
    <!--main css-->
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/sass/main.css" rel="stylesheet">
    <link href="assets/sass/dark-theme.css" rel="stylesheet">
    <link href="assets/sass/responsive.css" rel="stylesheet">
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
      body {
        animation: fadeIn 0.4s ease-in-out;
      }

      @keyframes fadeIn {
        from {
          opacity: 0;
        }

        to {
          opacity: 1;
        }
      }
    </style>
  </head>
  <body class="bg-login pt-3">
    <!--authentication-->
    <div class="container-fluid my-5">
      <div class="row">
        <div class="col-12 col-md-8 col-lg-6 col-xl-5 col-xxl-4 mx-auto">
          <div class="card rounded-4">
            <div class="card-body p-5 text-center">
              <img src="assets/images/patra.png" class="mb-4" width="145" alt="">
              <h4 class="fw-bold">Get Started Now</h4>
              <p class="mb-0">Enter your credentials to login your account</p>
              <div class="form-body my-4 ">
                <form class="row g-3" id="formLogin" method="POST">
                  <div class="col-12">
                    <label for="inputEmailAddress" class="form-label">Username</label>
                    <input type="text" class="form-control" id="inputEmailAddress" name="username" placeholder="Username" autofocus required>
                  </div>
                  <div class="col-12">
                    <label for="inputChoosePassword" class="form-label">Password</label>
                    <div class="input-group" id="show_hide_password">
                      <input type="password" class="form-control" id="inputChoosePassword" name="password" placeholder="Password" required>
                      <a href="javascript:;" class="input-group-text bg-transparent">
                        <i class="bi bi-eye-slash-fill"></i>
                      </a>
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="d-grid">
                      <button type="submit" class="btn btn-primary" name="submit">Login</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--end row-->
    </div>
    <!--authentication-->
    <!--plugins-->
    <script src="assets/js/jquery.min.js"></script>
    <script>
      $(document).ready(function() {
        // === PASSWORD TOGGLE ===
        $("#show_hide_password a").on('click', function(event) {
          event.preventDefault();
          const input = $('#show_hide_password input');
          const icon = $('#show_hide_password i');
          if (input.attr("type") === "text") {
            input.attr('type', 'password');
            icon.addClass("bi-eye-slash-fill").removeClass("bi-eye-fill");
          } else {
            input.attr('type', 'text');
            icon.removeClass("bi-eye-slash-fill").addClass("bi-eye-fill");
          }
        });
        // === FORM SUBMIT AJAX ===
        $("#formLogin").on('submit', function(e) {
          e.preventDefault(); // stop page reload
          $.ajax({
            url: "login_check.php",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            beforeSend: function() {
              Swal.fire({
                title: 'Memeriksa...',
                text: 'Harap tunggu sebentar',
                allowOutsideClick: false,
                didOpen: () => {
                  Swal.showLoading();
                }
              });
            },
            success: function(response) {
              Swal.close(); // tutup loading
              if (response.status === "success") {
                Swal.fire({
                  icon: "success",
                  title: "Berhasil Login!",
                  text: response.message,
                  timer: 1500,
                  showConfirmButton: false
                }).then(() => {
                  window.location = "index.php";
                });
              } else if (response.status === "warning") {
                Swal.fire({
                  icon: "warning",
                  title: "Perhatian!",
                  text: response.message,
                  confirmButtonColor: "#3085d6"
                });
              } else {
                Swal.fire({
                  icon: "error",
                  title: "Login Gagal!",
                  text: response.message,
                  confirmButtonColor: "#d33"
                });
              }
            },
            error: function() {
              Swal.close();
              Swal.fire({
                icon: "error",
                title: "Kesalahan Server!",
                text: "Terjadi kesalahan saat menghubungi server.",
                confirmButtonColor: "#d33"
              });
            }
          });
        });
      });
    </script>
  </body>
</html>